import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/route/route.dart';
import 'package:viser_remit/core/utils/dimensions.dart';
import 'package:viser_remit/core/utils/my_color.dart';
import 'package:viser_remit/core/utils/my_images.dart';
import 'package:viser_remit/core/utils/my_strings.dart';
import 'package:viser_remit/core/utils/style.dart';
import 'package:viser_remit/data/controller/auth/auth/registration_controller.dart';
import 'package:viser_remit/data/repo/auth/general_setting_repo.dart';
import 'package:viser_remit/data/repo/auth/signup_repo.dart';
import 'package:viser_remit/data/services/api_client.dart';
import 'package:viser_remit/view/components/custom_loader/custom_loader.dart';
import 'package:viser_remit/view/components/custom_no_data_found_class.dart';
import 'package:viser_remit/view/components/will_pop_widget.dart';
import 'package:viser_remit/view/screens/auth/registration/widget/registration_form.dart';

class RegistrationScreen extends StatefulWidget {
  const RegistrationScreen({Key? key}) : super(key: key);

  @override
  State<RegistrationScreen> createState() => _RegistrationScreenState();
}

class _RegistrationScreenState extends State<RegistrationScreen> with SingleTickerProviderStateMixin {
  TabController? tabController;

  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(GeneralSettingRepo(apiClient: Get.find()));
    Get.put(RegistrationRepo(apiClient: Get.find()));
    Get.put(RegistrationController(registrationRepo: Get.find(), generalSettingRepo: Get.find()));
    tabController = TabController(length: 2, vsync: this, initialIndex: 0);

    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((_) {
      Get.find<RegistrationController>().initData();
    });
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<RegistrationController>(
      builder: (controller) => WillPopWidget(
        nextRoute: RouteHelper.loginScreen,
        child: Scaffold(
          backgroundColor: MyColor.colorWhite,
          body: controller.noInternet
              ? NoDataOrInternetScreen(
                  isNoInternet: true,
                  onChanged: (value) {
                    controller.changeInternet(value);
                  },
                )
              : controller.isLoading
                  ? const CustomLoader()
                  : SingleChildScrollView(
                      physics: const BouncingScrollPhysics(),
                      child: Padding(
                        padding: const EdgeInsetsDirectional.only(start: Dimensions.space15, bottom: 30, end: Dimensions.space15),
                        child: Column(
                          children: [
                            SizedBox(height: MediaQuery.of(context).size.height * .06),
                            Center(
                              child: Image.asset(MyImages.appLogo, height: 60, width: 225),
                            ),
                            Container(
                              padding: const EdgeInsetsDirectional.symmetric(horizontal: Dimensions.space20, vertical: Dimensions.space25),
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(Dimensions.space10),
                                color: MyColor.getCardBgColor(),
                              ),
                              child: Column(
                                children: [
                                  SizedBox(height: MediaQuery.of(context).size.height * .01),
                                  Container(
                                    padding: const EdgeInsets.all(6),
                                    decoration: BoxDecoration(
                                        color: MyColor.primaryColor.withOpacity(.2), borderRadius: BorderRadius.circular(100)
                                    ),
                                    child: TabBar(
                                      splashFactory: NoSplash.splashFactory,
                                      overlayColor: WidgetStateProperty.resolveWith<Color?>((Set<WidgetState> states) {
                                        // Use the default focused overlay color
                                        return states.contains(WidgetState.focused) ? null : Colors.transparent;
                                      }),
                                      labelColor: MyColor.colorBlack,
                                      automaticIndicatorColorAdjustment: true,
                                      controller: tabController,
                                      unselectedLabelColor: MyColor.colorBlack,
                                      indicator: BoxDecoration(color: MyColor.colorWhite, borderRadius: BorderRadius.circular(100)),
                                      indicatorColor: MyColor.primaryColor,
                                      labelStyle: boldLarge,
                                      onTap: (value) {
                                        controller.setType(value.toString());
                                      },
                                      tabs: [
                                        Tab(
                                          text: MyStrings.personal.tr,
                                        ),
                                        Tab(
                                          text: MyStrings.business.tr,
                                        ),
                                      ],
                                    ),
                                  ),
                                  const SizedBox(height: Dimensions.space20),
                                  if (tabController!.index == 0)
                                    Column(
                                      children: [
                                        const RegistrationForm(),
                                        const SizedBox(height: Dimensions.space30),
                                        Wrap(
                                          crossAxisAlignment: WrapCrossAlignment.center,
                                          alignment: WrapAlignment.center,
                                          runAlignment: WrapAlignment.center,
                                          children: [
                                            Text(MyStrings.alreadyAccount.tr, style: regularLarge.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w500)),
                                            const SizedBox(width: Dimensions.space5),
                                            TextButton(
                                              onPressed: () {
                                                controller.clearAllData();
                                                Get.offAndToNamed(RouteHelper.loginScreen);
                                              },
                                              child: Text(MyStrings.signIn.tr, style: regularLarge.copyWith(color: MyColor.getPrimaryColor())),
                                            )
                                          ],
                                        )
                                      ],
                                    ),
                                  if (tabController!.index == 1)
                                    Column(
                                      children: [
                                        const RegistrationForm(
                                          businessField: true,
                                        ),
                                        const SizedBox(height: Dimensions.space30),
                                        Wrap(
                                          crossAxisAlignment: WrapCrossAlignment.center,
                                          alignment: WrapAlignment.center,
                                          runAlignment: WrapAlignment.center,
                                          children: [
                                            Text(MyStrings.alreadyAccount.tr, style: regularLarge.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w500)),
                                            const SizedBox(width: Dimensions.space5),
                                            TextButton(
                                              onPressed: () {
                                                controller.clearAllData();
                                                Get.offAndToNamed(RouteHelper.loginScreen);
                                              },
                                              child: Text(MyStrings.signIn.tr, style: regularLarge.copyWith(color: MyColor.getPrimaryColor())),
                                            )
                                          ],
                                        )
                                      ],
                                    ),
                                ],
                              ),
                            )
                          ],
                        ),
                      ),
                    ),
        ),
      ),
    );
  }
}
